%**************************************************************************
% readXPMPro.m
%**************************************************************************

%**************************************************************************
% primary function
%**************************************************************************
function readXPMProOneSpec
    %cd('C:\Documents and Settings\All Users\Documents\FromShareRHK\STM_05');
    
    % open data file
%     cd('C:\Documents and Settings\All Users\Documents\FromShareRHK\');
%     [filename, pathname] = uigetfile('*.sm4', 'Pick an SM4-file');
%     if isequal(filename,0)
%         disp('User selected Cancel')
%     else
filename = '09_04_22_Spec_0000.SM4';
pathname = 'C:\Documents and Settings\All Users\Documents\FromShareRHK\';
        disp(['User selected', fullfile(pathname, filename)])
        % extract filename root for output files
        filenameLen = length(filename);
        filenameRoot = filename(1:filenameLen-4); % remove '.sm4'
        filenameR = sprintf('%s%s.%s', pathname, filenameRoot,'sm4');
        fid = fopen(filenameR,'r');
        RHK = readFileHeader(fid);
        pageHeader = readPageHeader(fid,RHK.pageHeader(1).offset);
        spectralDriftData = readSpectralDriftData(fid,pageHeader);    
        spectralData = readSpectralData(fid,pageHeader,RHK.pageData(1).offset);
        fclose(fid);
numPoints=1
        Xaxis = calculateXaxis(pageHeader);
        aveSpectralData = calculateAveSpectralData(pageHeader,spectralData,numPoints);
%        plotAveSpectralData(Xaxis,aveSpectralData,numPoints);
        diffSpectralData = calculateDiffSpectralData(pageHeader,aveSpectralData,numPoints,Xaxis);
        plotDiffSpectralDataData(pageHeader,Xaxis,diffSpectralData,numPoints);
%    plot(Xaxis(1:pageHeader.width-1,1),diffSpectralData(:,1));

    filenameInf = sprintf('%s%s.%s', pathname, filenameRoot,'txt');
    fidIV = fopen(filenameInf,'w');
    for i=1:pageHeader.width-1
        fprintf(fidIV,'%f\t%e\n',Xaxis(i),diffSpectralData(i,numPoints));
    end
    fclose(fidIV);



        printFileInfo(pathname, filenameRoot,RHK,pageHeader, spectralDriftData);
%       end
%**************************************************************************
% END primary function
%**************************************************************************

%**************************************************************************
% calculateDiffSpectralData
%**************************************************************************
function diffSpectralData = calculateDiffSpectralData(pageHeader,aveSpectralData,numPoints,Xaxis)
    diffSpectralData = zeros(pageHeader.width-1,numPoints);
    for j=1:numPoints
        for i=1:pageHeader.width-1
            diffSpectralData(i,j)=( aveSpectralData(i+1,j)-aveSpectralData(i,j) )/(Xaxis(i+1)-Xaxis(i));
        end
    end
    aveSpectralData(1,1)
    aveSpectralData(2,1)
    Xaxis(1)
    Xaxis(2)
    diffSpectralData(1,1)
%**************************************************************************
% END calculateDiffSpectralData
%**************************************************************************

%**************************************************************************
% plotDiffSpectralDataData
%**************************************************************************
function plotDiffSpectralDataData(pageHeader,Xaxis,diffSpectralData,numPoints)
    plot(Xaxis(1:pageHeader.width-1,1),diffSpectralData(:,1));
    hold all % hold plot and cycle line colors
    for i = 2:numPoints
        plot(Xaxis(1:pageHeader.width-1,1),diffSpectralData(:,i));
    end
    hold off
%**************************************************************************
% END plotDiffSpectralDataData
%**************************************************************************

%**************************************************************************
% calculateAveSpectralData
%**************************************************************************
function aveSpectralData = calculateAveSpectralData(pageHeader,spectralData,numPoints)
    aveSpectralData = zeros(pageHeader.width,numPoints);
    IVperPoint = pageHeader.height/numPoints;
    for point =1:numPoints
        curve1 = (point-1)*IVperPoint+1;
        curve2 = point*IVperPoint;
        for voltage = 1:pageHeader.width
            for i = curve1:curve2
                aveSpectralData(voltage,point) = aveSpectralData(voltage,point)+ spectralData(voltage,i);
            end
        end
    end
    aveSpectralData(:,:)=pageHeader.Zscale*aveSpectralData(:,:)/IVperPoint;
%**************************************************************************
% END calculateAveSpectralData
%**************************************************************************


%**************************************************************************
% calculateXaxis
%**************************************************************************
    function Xaxis = calculateXaxis(pageHeader)
    Xaxis = zeros(pageHeader.width,1);
    for voltage = 1:pageHeader.width
        Xaxis(voltage) = pageHeader.Xoffset + voltage*pageHeader.Xscale;
    end
%**************************************************************************
% END calculateXaxis
%**************************************************************************


%**************************************************************************
% plotAveSpectralData
%**************************************************************************
function plotAveSpectralData(Xaxis,aveSpectralData,numPoints)
    plot(Xaxis(:,1),aveSpectralData(:,1));
    hold all % hold plot and cycle line colors
    for i = 2:numPoints
    plot(Xaxis(:,1),aveSpectralData(:,i));
    end
    hold off
%**************************************************************************
% END plotAveSpectralData
%**************************************************************************


%**************************************************************************
%read spectral data
%**************************************************************************
function spectralData = readSpectralData(fid,pageHeader,IVdataOffset)
    fseek(fid,IVdataOffset,'bof');
    pageHeader.width
    pageHeader.height
     spectralData = zeros(pageHeader.width,pageHeader.height);
     [spectralData,count] = fread(fid, [pageHeader.width,pageHeader.height], 'int');
%**************************************************************************
%END read spectral data
%**************************************************************************

%**************************************************************************
%read spectral drift data
%**************************************************************************
function spectralDriftData = readSpectralDriftData(fid,pageHeader)
    fseek(fid,pageHeader.object(5).offset,'bof');
    for i = 1:pageHeader.height
        spectralDriftData(i).time = fread(fid, 1,'float');
        spectralDriftData(i).Xcoord = fread(fid, 1,'float');
        spectralDriftData(i).Ycoord = fread(fid, 1,'float');
        spectralDriftData(i).dX = fread(fid, 1,'float');
        spectralDriftData(i).dY = fread(fid, 1,'float');
        spectralDriftData(i).cumulativedX = fread(fid, 1,'float');
        spectralDriftData(i).cumulativedY = fread(fid, 1,'float');
%        spectralDrift(i)
    end
%**************************************************************************
% END read spectral drift data
%**************************************************************************

%**************************************************************************
% function read page header string data
%**************************************************************************
function readPageHeaderStringData(fid,pageHeader)
     fseek(fid,pageHeader.object(1).offset,'bof');
     for i = 1:pageHeader.stringCount
         strData = fread(fid, fread(fid, 1,'short'),'short'); % do not keep
     end
%      1. label
%      2. systemText
%      3. sessionText
%      4. userText
%      5. path
%      6. date
%      7. time
%      8. Xunits
%      9. Yunits
%      10. Zunits
%      11. Xlabel
%      12. Ylabel
%      13. statusChannelText
%      14. completedLineCount
%      15. overSamplingCount
%      16. slicedVoltage
%      17. PLLproStatus

%**************************************************************************
% END read page header string data
%**************************************************************************


%**************************************************************************
% function read file header
%**************************************************************************
 function RHK = readFileHeader(fid)
    RHK.fileHeader.Size = fread(fid, 1, 'short');
    RHK.fileHeader.version = fread(fid, 18,'short');
    RHK.fileHeader.totalPageCount = fread(fid, 1, 'int');
    RHK.fileHeader.objectListCount = fread(fid, 1, 'int');
    RHK.fileHeader.objectFieldSize = fread(fid, 1, 'int');
%char(RHK.fileHeader.version)
    fseek(fid,8,'cof'); % reserved for future use

    %Read object list
%    disp('Read object list');
    for i = 1:RHK.fileHeader.objectListCount
        RHK.fileHeader.object(i).ID = fread(fid, 1, 'int');
        RHK.fileHeader.object(i).offset = fread(fid, 1, 'int');
        RHK.fileHeader.object(i).size = fread(fid, 1, 'int');
%        RHK.fileHeader.object(i)
    end
%     objects
%     1. Page Index Header
%     2. PRM Data
%     3. PRM Header

    %read page index header
%    disp('read page index header');
    RHK.pageIndexheader.pageCount = fread(fid, 1, 'int');
    RHK.pageIndexheader.objectListCount = fread(fid, 1, 'int');
%    RHK.pageIndexheader    
    fseek(fid,8,'cof'); % reserved for future use
    
    %read object list
    for i = 1:RHK.pageIndexheader.objectListCount
        RHK.pageIndexheader.object(i).ID = fread(fid, 1, 'int');
        RHK.pageIndexheader.object(i).offset = fread(fid, 1, 'int');
        RHK.pageIndexheader.object(i).size = fread(fid, 1, 'int');
%        RHK.objectList(i)
    end
%     objects
%     1. Page Index Array

    %read page index array
    for i = 1:RHK.fileHeader.totalPageCount % one per page
%        sprintf('read page index array [%d]',i)
        RHK.pageIndexArray(i).Data1 = fread(fid, 1, 'long');
        RHK.pageIndexArray(i).Data2 = fread(fid, 1, 'short');
        RHK.pageIndexArray(i).Data3 = fread(fid, 1, 'short');
        RHK.pageIndexArray(i).Data4 = fread(fid, 8, 'char');
        RHK.pageIndexArray(i).pageDataType = fread(fid, 1, 'int');
        RHK.pageIndexArray(i).pageSourceType = fread(fid, 1, 'int');
        RHK.pageIndexArray(i).objectListCount = fread(fid, 1, 'int');
        RHK.pageIndexArray(i).minorVersion = fread(fid, 1, 'int');
%RHK.pageIndexArray(i)

        RHK.pageHeader(i).ID = fread(fid, 1, 'int');
        RHK.pageHeader(i).offset = fread(fid, 1, 'int');
        RHK.pageHeader(i).size = fread(fid, 1, 'int');
%RHK.pageHeader(i)

        RHK.pageData(i).ID = fread(fid, 1, 'int');
        RHK.pageData(i).offset = fread(fid, 1, 'int');
        RHK.pageData(i).size = fread(fid, 1, 'int');
%RHK.pageData(i)

        RHK.Thumbnail(i).ID = fread(fid, 1, 'int');
        RHK.Thumbnail(i).offset = fread(fid, 1, 'int');
        RHK.Thumbnail(i).size = fread(fid, 1, 'int');
%RHK.Thumbnail(i)

        RHK.ThumbnailHeader(i).ID = fread(fid, 1, 'int');
        RHK.ThumbnailHeader(i).offset = fread(fid, 1, 'int');
        RHK.ThumbnailHeader(i).size = fread(fid, 1, 'int');
%RHK.ThumbnailHeader(i)
    end
    %RHK
%**************************************************************************
% END function read file header
%**************************************************************************


%**************************************************************************
% function read page header
%**************************************************************************
 function pageHeader = readPageHeader(fid,pageOffset)
     fseek(fid,pageOffset,'bof');
     pageHeader.fieldSize = fread(fid, 1, 'short');
%     pageHeader.signature = fread(fid, 18,'char');
     pageHeader.stringCount = fread(fid, 1,'short');
%     pageHeader.type = fread(fid, 1,'int');
     pageHeader.pageType = fread(fid, 1,'int');
     pageHeader.dataSubSource = fread(fid, 1,'int');
     pageHeader.lineType = fread(fid, 1,'int');
     pageHeader.x = fread(fid, 1,'int');
     pageHeader.y = fread(fid, 1,'int');
     pageHeader.width = fread(fid, 1,'int');
     pageHeader.height = fread(fid, 1,'int');
%     pageHeader.sourceType = fread(fid, 1,'int');
     pageHeader.imageType = fread(fid, 1,'int');
     pageHeader.scan = fread(fid, 1,'int');
     pageHeader.groupID = fread(fid, 1,'int');
     pageHeader.pageDataSize = fread(fid, 1,'uint32');
     pageHeader.minZ = fread(fid, 1,'uint32');
     pageHeader.maxZ = fread(fid, 1,'uint32');
     pageHeader.Xscale = fread(fid, 1,'float');
     pageHeader.Yscale = fread(fid, 1,'float');
     pageHeader.Zscale = fread(fid, 1,'float');
     pageHeader.XYscale = fread(fid, 1,'float');
     pageHeader.Xoffset = fread(fid, 1,'float');
     pageHeader.Yoffset = fread(fid, 1,'float');
     pageHeader.Zoffset = fread(fid, 1,'float');
     pageHeader.period = fread(fid, 1,'float');
     pageHeader.bias = fread(fid, 1,'float');
     pageHeader.current = fread(fid, 1,'float');
     pageHeader.angle = fread(fid, 1,'float');
     pageHeader.colorInfoListCount = fread(fid, 1,'int');
     pageHeader.Xsize = fread(fid, 1,'int');
     pageHeader.Ysize = fread(fid, 1,'int');
     pageHeader.objectListCount = fread(fid, 1,'int');
     fseek(fid,64,'cof'); % reserved for future use
     for i = 1:pageHeader.objectListCount
         pageHeader.object(i).ID = fread(fid, 1, 'int');
         pageHeader.object(i).offset = fread(fid, 1, 'int');
         pageHeader.object(i).size = fread(fid, 1, 'int');
     end
%      objects:     
%      1. String Data
%      2. Image Drift header
%      3. Image Drift Data
%      4. Spec Drift Header
%      5. Spectral Data
%      6. Color Info
%      7. Tip-track Info Header
%      8. Tip-track Data

%pageHeader

%**************************************************************************
% END page_header
%**************************************************************************


%**************************************************************************
% print file info
%**************************************************************************
function printFileInfo(pathname, filenameRoot,RHK,pageHeader, spectralDrift)
    filenameInf = sprintf('%s%sHeader.%s', pathname, filenameRoot,'txt');
    fidInf = fopen(filenameInf,'w');
    fprintf(fidInf,'RHK.fileHeader.Size = %d\n',RHK.fileHeader.Size);
    fprintf(fidInf,'RHK.fileHeader.version = ');
    fprintf(fidInf,'%c',RHK.fileHeader.version);
    fprintf(fidInf,'\n');
%    fprintf(fidInf,'RHK. = %d\n',RHK.);
    fprintf(fidInf,'RHK.fileHeader.totalPageCount = %d\n',RHK.fileHeader.totalPageCount);
    fprintf(fidInf,'RHK.fileHeader.objectListCount = %d\n',RHK.fileHeader.objectListCount);
     for i = 1:RHK.fileHeader.objectListCount
        fprintf(fidInf,'RHK.fileHeader.object(%d).ID = %d\n',i,RHK.fileHeader.object(i).ID);
        fprintf(fidInf,'RHK.fileHeader.object(%d).offset = %d\n',i,RHK.fileHeader.object(i).offset);
        fprintf(fidInf,'RHK.fileHeader.object(%d).size = %d\n',i,RHK.fileHeader.object(i).size);
     end
    fprintf(fidInf,'RHK.pageIndexheader.pageCount = %d\n',RHK.pageIndexheader.pageCount);
    fprintf(fidInf,'RHK.pageIndexheader.objectListCount = %d\n',RHK.pageIndexheader.objectListCount);
%     
%     %read object list
     for i = 1:RHK.pageIndexheader.objectListCount
          fprintf(fidInf,'RHK.pageIndexheader.object(%d).ID = %d\n',i,RHK.pageIndexheader.object(i).ID);
%         RHK.objectList(i).ID = fread(fid, 1, 'int');
          fprintf(fidInf,'RHK.pageIndexheader.object(%d).offset = %d\n',i,RHK.pageIndexheader.object(i).offset);
%         RHK.objectList(i).offset = fread(fid, 1, 'int');
          fprintf(fidInf,'RHK.pageIndexheader.object(%d).size = %d\n',i,RHK.pageIndexheader.object(i).size);
%         RHK.objectList(i).size = fread(fid, 1, 'int');
     end
% 
%     %read page index array
     for i = 1:RHK.fileHeader.totalPageCount
% %        sprintf('read page index array [%d]',i)
%         RHK.pageIndexArray(i).Data1 = fread(fid, 1, 'long');
    fprintf(fidInf,'RHK.pageIndexArray(%d).Data1 = %d\n',i,RHK.pageIndexArray(i).Data1);
%         RHK.pageIndexArray(i).Data2 = fread(fid, 1, 'short');
    fprintf(fidInf,'RHK.pageIndexArray(%d).Data2 = %d\n',i,RHK.pageIndexArray(i).Data2);
%         RHK.pageIndexArray(i).Data3 = fread(fid, 1, 'short');
    fprintf(fidInf,'RHK.pageIndexArray(%d).Data3 = %d\n',i,RHK.pageIndexArray(i).Data3);
%         RHK.pageIndexArray(i).Data4 = fread(fid, 8, 'char');
    fprintf(fidInf,'RHK.pageIndexArray(%d).Data4 = ',i);
    fprintf(fidInf,'%c',RHK.pageIndexArray(i).Data4);
    fprintf(fidInf,'\n');
%         RHK.pageIndexArray(i).pageDataType = fread(fid, 1, 'int');
    fprintf(fidInf,'RHK.pageIndexArray(%d).pageDataType = %d\n',i,RHK.pageIndexArray(i).pageDataType);
%         RHK.pageIndexArray(i).pageSourceType = fread(fid, 1, 'int');
    fprintf(fidInf,'RHK.pageIndexArray(%d).pageSourceType = %d\n',i,RHK.pageIndexArray(i).pageSourceType);
%         RHK.pageIndexArray(i).objectListCount = fread(fid, 1, 'int');
    fprintf(fidInf,'RHK.pageIndexArray(%d).objectListCount = %d\n',i,RHK.pageIndexArray(i).objectListCount);
%         RHK.pageIndexArray(i).minorVersion = fread(fid, 1, 'int');
    fprintf(fidInf,'RHK.pageIndexArray(%d).minorVersion = %d\n',i,RHK.pageIndexArray(i).minorVersion);
% %        RHK.pageIndexArray(i)
% 
%         RHK.pageHeader(i).ID = fread(fid, 1, 'int');
    fprintf(fidInf,'RHK.pageHeader(%d).ID = %d\n',i,RHK.pageHeader(i).ID);
%         RHK.pageHeader(i).offset = fread(fid, 1, 'int');
    fprintf(fidInf,'RHK.pageHeader(%d).offset = %d\n',i,RHK.pageHeader(i).offset);
%         RHK.pageHeader(i).size = fread(fid, 1, 'int');
    fprintf(fidInf,'RHK.pageHeader(%d).size = %d\n',i,RHK.pageHeader(i).size);
% %       RHK.pageHeader(i)
% 
%         RHK.pageData(i).ID = fread(fid, 1, 'int');
    fprintf(fidInf,'RHK.pageData(%d).ID = %d\n',i,RHK.pageData(i).ID);
    fprintf(fidInf,'RHK.pageData(%d).offset = %d\n',i,RHK.pageData(i).offset);
    fprintf(fidInf,'RHK.pageData(%d).size = %d\n',i,RHK.pageData(i).size);
%         RHK.pageData(i).offset = fread(fid, 1, 'int');
%         RHK.pageData(i).size = fread(fid, 1, 'int');
% %       RHK.pageData(i)
% 
    fprintf(fidInf,'RHK.Thumbnail(%d).ID = %d\n',i,RHK.Thumbnail(i).ID);
    fprintf(fidInf,'RHK.Thumbnail(%d).offset = %d\n',i,RHK.Thumbnail(i).offset);
    fprintf(fidInf,'RHK.Thumbnail(%d).size = %d\n',i,RHK.Thumbnail(i).size);
%         RHK.Thumbnail(i).ID = fread(fid, 1, 'int');
%         RHK.Thumbnail(i).offset = fread(fid, 1, 'int');
%         RHK.Thumbnail(i).size = fread(fid, 1, 'int');
% %      RHK.Thumbnail(i)
% 
    fprintf(fidInf,'RHK.ThumbnailHeader(%d).ID = %d\n',i,RHK.ThumbnailHeader(i).ID);
    fprintf(fidInf,'RHK.ThumbnailHeader(%d).offset = %d\n',i,RHK.ThumbnailHeader(i).offset);
    fprintf(fidInf,'RHK.ThumbnailHeader(%d).size = %d\n',i,RHK.ThumbnailHeader(i).size);
%         RHK.ThumbnailHeader(i).ID = fread(fid, 1, 'int');
%         RHK.ThumbnailHeader(i).offset = fread(fid, 1, 'int');
%         RHK.ThumbnailHeader(i).size = fread(fid, 1, 'int');
% %      RHK.ThumbnailHeader(i)
     end
%         
        
        fclose(fidInf);
%**************************************************************************
% END print file info
%**************************************************************************
